function descriptor()

  return { title = "Scenerixx Bridge - I came",
    version = "0.2",
    author = "ScenerixxDev",
    url = "www.scenerixx.com",
	shortdesc = "Scenerixx Bridge - I came",
	description = "This plugin is a bridge into your local Scenerixx installation",
	capabilities = {"input-listener", "meta-listener", "playing-listener"},
  }
end

function activate()
        vlc.msg.dbg("activate- i came")
		iCame()
  return true
end

function iCame()
    vlc.msg.dbg("iCame")
    local res = get("http://localhost:7679/api/v1/iCame?filename="..getCurrentFile().."&time="..getFormatedTime())
    if(string.find(res, "i came")) then
	vlc.osd.message("I came at "..getFormatedTime())
    else
	vlc.osd.message("An error occured - maybe no scene length set")		
    end
end

function get(url)
  vlc.msg.dbg("passed url: "..url)
  local u = vlc.net.url_parse(url)
  vlc.msg.dbg("passed options: "..u["option"])
  local host, port, path, params = u["host"], u["port"], u["path"], u["option"]
  local header = {
    "GET "..path.."?"..params.." HTTP/1.1",
    "Host: "..host,
    "",
    ""
  }
  local request = table.concat(header, "\r\n")
  vlc.msg.dbg("request: "..request)
  return http_req(host, port, request)
end

function http_req(host, port, request)
  vlc.msg.dbg("host "..host)
  vlc.msg.dbg("port "..port)
  vlc.msg.dbg("request "..request)
  local fd = vlc.net.connect_tcp(host, port)
  vlc.msg.dbg("fd "..fd)
  if not fd then return false end

  if fd==3 then 
	vlc.osd.message("Cannot connect to server - is ScenerixxHub running?")
	return false 
  end
  
  local pollfds = {}

  pollfds[fd] = vlc.net.POLLIN
  vlc.net.send(fd, request)
  vlc.net.poll(pollfds)

  vlc.msg.dbg("start receivingX")
  local chunk = vlc.net.recv(fd, 2048)
  vlc.msg.dbg("chunk: "..chunk)
  vlc.msg.dbg("close now ")
  vlc.net.close(fd)
  return chunk
end

function getFormatedTime()
  local duration = getTimePassed()
  duration = duration / 1000 / 1000
  vlc.msg.dbg("duration raw: "..duration)
  --globalstart = duration
  
  local formatedTime = string.format("%02d:%02d:%02d",
                         math.floor(duration/3600),
                         math.floor(duration/60)%60,
                         math.floor(duration%60))
						 	
							vlc.msg.dbg("hi: "..formatedTime)
	if (formatedTime == nil) then
		return -1
	else
		return formatedTime	
	end
end

function getCurrentFile()
		local item = vlc.input.item()
		local uri = item:uri()
		vlc.msg.dbg("current uri: "..uri)
		uri = string.gsub(uri, '&', '%%26')
		uri = string.gsub(uri, '^file:///', '')
		uri = string.gsub(uri, '\\', '\\\\')
		vlc.msg.dbg("current file "..uri)
		return uri
end

function close()
  vlc.msg.dbg("[Scenerixx Bridge] Close")
end

function deactivate()
  local duration = getTimePassed()
  duration = duration / 1000 / 1000
  vlc.msg.dbg("time passed on deactivation: "..duration)
  activate()
end

function getTimePassed()
    if (vlc.object.input() == nil) then
	return -1
    else
        return vlc.var.get(vlc.object.input(), "time")
    end
end

function input_changed()
   -- related to capabilities={"input-listener"} in descriptor()
   -- triggered by Start/Stop media input event
   vlc.msg.dbg("input changed " .. vlc.playlist.status())
end

function playing_changed()
   -- related to capabilities={"playing-listener"} in descriptor()
   -- triggered by Pause/Play madia input event
	vlc.msg.dbg("playing changed " .. vlc.playlist.status())
end

function meta_changed()
	vlc.msg.dbg("meta changed " .. vlc.playlist.status())
end
